﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Types" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Ewidencja VAT do marży</title>
	<script runat="server">

		private void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			NagEwidencjiVATSprzedaz nag = (NagEwidencjiVATSprzedaz)args.Row;
			SprzedazEwidencja ewid = (SprzedazEwidencja)nag.Ewidencja;
			VATMarzaEwidencja.VATMarzaInfoWorker worker = new VATMarzaEwidencja.VATMarzaInfoWorker(ewid);

			colNumer.EditValue = nag.Numer;
			colNumerDokumentu.EditValue = nag.NumerDokumentu;
			colDataDokumentu.EditValue = nag.DataDokumentu;
			colDefinicja.EditValue = nag.Definicja.Symbol;
			colWartosc.EditValue = worker.VATOdMarzyWartoscBrutto.Value;
			colKoszt.EditValue = worker.VATOdMarzyKosztZakupu.Value;

			VATMarzaEwidencja.VATMarzaInfoWorker.KwotyStawki item = null;
			item = worker.VATOdMarzyKwotyStawki(ZW);
			if (item != null)
				colNettoZw.EditValue = item.Netto.Value;
			else
				colNettoZw.EditValue = 0m;

			item = worker.VATOdMarzyKwotyStawki(Op0);
			if (item != null)
				colNetto0.EditValue = item.Netto.Value;
			else
				colNetto0.EditValue = 0m;

			item = worker.VATOdMarzyKwotyStawki(Op8);
			if (item != null)
			{
				colNetto8.EditValue = item.Netto.Value;
				colVAT8.EditValue = item.VAT.Value;
			}
			else
			{
				colNetto8.EditValue = 0m;
				colVAT8.EditValue = 0m;
			}

			item = worker.VATOdMarzyKwotyStawki(Op5);
			if (item != null)
			{
				colNetto5.EditValue = item.Netto.Value;
				colVAT5.EditValue = item.VAT.Value;
			}
			else
			{
				colNetto5.EditValue = 0m;
				colVAT5.EditValue = 0m;
			}

			item = worker.VATOdMarzyKwotyStawki(Op23);
			if (item != null)
			{
				colNetto23.EditValue = item.Netto.Value;
				colVAT23.EditValue = item.VAT.Value;
			}
			else
			{
				colNetto23.EditValue = 0m;
				colVAT23.EditValue = 0m;
			}

			DaneKontrahenta danePodmiotu = ewid.DaneKontrahenta;

			string kod = nag.Podmiot.Kod;
			if (danePodmiotu.EuVAT != "")
				kod += string.Format(" ({0})", danePodmiotu.EuVAT);
			colKod.EditValue = kod;
			colNazwa.EditValue = string.Format("{0} {1}", danePodmiotu.Nazwa, danePodmiotu.Adres);
			colOpis.EditValue = ewid.VATMarza.Opis;

			colNetto.EditValue = worker.VATOdMarzyNetto.Value;
			colVAT.EditValue = worker.VATOdMarzyVAT.Value;
			colBrutto.EditValue = worker.VATOdMarzyBrutto.Value;

		}

		DefinicjaStawkiVat NP = null, ZW = null, Op23 = null, Op8 = null, Op5 = null, Op0 = null;
		
		
		void EwidencjaVAT_OnLoad(Object sender, EventArgs args)
		{
			NagEwidencjiVATT.Params p = null;
			if (DataContext1.Context.Contains(typeof(NagEwidencjiVATT.Params)))
				p = (NagEwidencjiVATT.Params)DataContext1.Get(typeof(NagEwidencjiVATT.Params));


			string tytul = "";
			colData.DataMember = "DataZaewidencjonowania";
			tytul = "Ewidencja VAT od marży";

			ReportHeader1.Title =
			  string.Format(ReportHeader1.Title,
			  tytul, p.Typ, p.Zakres, p.Definicja == null ? "Wszystkie" : p.Definicja.ToString(),
			  p.Podmiot == null ? "Wszyscy" : p.Podmiot.ToString(), p.Korekty,p.ApplyAspxParamsForProceduresVAT());

			DefStawekVat definicjeStawek = CoreModule.GetInstance(DataContext1.Session).DefStawekVat;

			NP = definicjeStawek[DefinicjaStawkiVat.NP];
			ZW = definicjeStawek[DefinicjaStawkiVat.ZW];
			Op23 = definicjeStawek[DefinicjaStawkiVat.Op23];
			Op8 = definicjeStawek[DefinicjaStawkiVat.Op8];
			Op5 = definicjeStawek[DefinicjaStawkiVat.Op5];
			Op0 = definicjeStawek[DefinicjaStawkiVat.Op0];

			ArrayList arr = new ArrayList();
			foreach (NagEwidencjiVAT nag in ((Row[])DataContext1.Context[typeof(Row[])]))
			{
				SprzedazEwidencja ewid = nag.Ewidencja as SprzedazEwidencja;
				if (ewid != null && ewid.VATMarza != null)
					arr.Add(nag);
			}

			Grid1.DataSource = arr;

		}

	</script>
</head>
<body>
	<form id="EwidencjaVAT" method="post" runat="server" onload="EwidencjaVAT_OnLoad">
	<ea:DataContext ID="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business" Landscape="True" />
	<cc1:ReportHeader ID="ReportHeader1" Title="{0} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3}, Podmiot: {4}, Korekty: {5}|{6}" runat="server" />

	<ea:Grid ID="Grid1" runat="server" RowTypeName="Soneta.EwidencjaVat.NagEwidencjiVATSprzedaz,Soneta.Ksiega" RowsInRow="3" OnBeforeRow="Grid1_BeforeRow" ShowPrevAgrSum="InFooter" ShowPageSum="True" ShowAgrSum="True">
		<Columns>
			<ea:GridColumn runat="server" Width="5" DataMember="#" Caption="Lp" ID="colLp" RowSpan="3" />
			<ea:GridColumn runat="server" Caption="Nr ewid." ID="colNumer"/>
			<ea:GridColumn runat="server" Caption="Nr dok." ID="colNumerDokumentu"/>
			<ea:GridColumn runat="server" Caption="Opis(dok. zakupu)" ID="colOpis"/>
			<ea:GridColumn runat="server" Width="10" Align="Center" Caption="Data zaew." ID="colData"/>
			<ea:GridColumn runat="server" ColSpan="3" Caption="Podmiot (Kod + NIP)" ID="colKod"/>
			<ea:GridColumn runat="server" ColSpan="8" Caption="Podmiot (Nazwa + Adres)" ID="colNazwa"/>
			<ea:GridColumn runat="server" Width="10" Align="Center" Caption="Data dok." ID="colDataDokumentu"/>
			<ea:GridColumn runat="server" Width="8" Align="Center" Caption="Definicja" ID="colDefinicja"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Caption="Wartość" Format="{0:n}" ID="colWartosc"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Caption="Koszt zak." Format="{0:n}" ID="colKoszt"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 5%" Format="{0:n}" ID="colNetto5"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 5%" Format="{0:n}" ID="colVAT5"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 8%" Format="{0:n}" ID="colNetto8"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 8%" Format="{0:n}" ID="colVAT8"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 23%" Format="{0:n}" ID="colNetto23"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 23%" Format="{0:n}" ID="colVAT23"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Wart. zw." Format="{0:n}" ID="colNettoZw"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Wart. 0%" Format="{0:n}" ID="colNetto0"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto" Format="{0:n}" ID="colNetto"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT" Format="{0:n}" ID="colVAT"/>
			<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Brutto" Format="{0:n}" ID="colBrutto"/>
		</Columns>
	</ea:Grid>
	<cc1:ReportFooter ID="ReportFooter1" runat="server" />
	</form>
</body>
</html>

